<?php
// Configurações
$usuario = 'root';
$senha = ''; // Coloque sua senha se tiver
$host = 'localhost';
$data = date('Y-m-d_H-i-s');
$pasta_destino = __DIR__ . "/backups";

if (!is_dir($pasta_destino)) {
    mkdir($pasta_destino, 0777, true);
}

// Conecta ao MySQL
$conn = new mysqli($host, $usuario, $senha);
if ($conn->connect_error) {
    die("Erro ao conectar: " . $conn->connect_error);
}

// Lista todos os bancos
$resultado = $conn->query("SHOW DATABASES");
while ($row = $resultado->fetch_assoc()) {
    $banco = $row['Database'];

    // Ignorar bancos do sistema
    if (in_array($banco, ['information_schema', 'mysql', 'performance_schema', 'sys'])) {
        continue;
    }

    $arquivo = "$pasta_destino/{$banco}_{$data}.sql";
    $comando = "mysqldump -u $usuario" . ($senha ? " -p$senha" : "") . " $banco > \"$arquivo\"";
    system($comando);
}

echo "Backup realizado com sucesso em: $pasta_destino";
?>
